//%attributes = {}
// Method: _pdf_ OptionsSet 
// 10.03.11, 00:36:50 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// copied from PDFUnderWindows.4dbase
// ------------------------------------------------------------

// METHOD_NAME : PDFCreator_Set_Options
// Username : jpupier
// Created : 09/04/09, 09:25:08
// ============================================================================
// Description
// Setup PDFCreator driver prefs, Handles errors
//
// Parameters

// PDF_for_Windows_Advanced($OutputDir_t;$FileName_t 
//                                     {;$Author_t

//                                     {;$DocName_t
//                                     {;$Keywords_t
//                                     {;$AuthPass_t
//                                     {;$ReaderPass_t
//                                     {;$DisallowCopy_l
//                                     {;$DisallowAnnotate_l
//                                     {;$DisallowModify_l
//                                     {;$DisallowPrint_l }}}}}}}}})
// 
//

C_LONGINT:C283($0; $_pdf_lError)
$_pdf_lError:=0
C_TEXT:C284($1; $_pdf_tOutputDir)
C_TEXT:C284($2; $_pdf_tFileName)

C_TEXT:C284($3; $_pdf_tAuthor)
C_TEXT:C284($4; $_pdf_tDocName)
C_TEXT:C284($5; $_pdf_tKeywords)
C_TEXT:C284($6; $_pdf_tAuthPass)
C_TEXT:C284($7; $_pdf_tReaderPass)

C_LONGINT:C283($8; $_pdf_lDisallowCopy)
C_LONGINT:C283($9; $_pdf_lDisallowAnnotate)
C_LONGINT:C283($10; $_pdf_lDisallowModify)
C_LONGINT:C283($11; $_pdf_lDisallowPrint)

// ----------------------------------------------------
// Local_Variables
C_LONGINT:C283($Error)
C_TEXT:C284($_pdf_tDriverName)
C_TEXT:C284($_pdf_tOldPrinter)
C_BOOLEAN:C305($_pdf_fSwitchedDriver)
C_BOOLEAN:C305($_pdf_fValueSet)
//
// ----------------------------------------------------
// Local_Init

//
// ----------------------------------------------------
// ============================================================================


// =================== [ Check parameters ] =====================
If ($_pdf_lError=0)
	If (Count parameters:C259<2)
		$_pdf_lError:=-1
	End if 
End if 

If ($_pdf_lError=0)
	$_pdf_tOutputDir:=$1
	$_pdf_tFileName:=$2
End if 


If ($_pdf_lError=0)
	If ($_pdf_tOutputDir="")
		$_pdf_lError:=-2
	End if 
End if 

If ($_pdf_lError=0)
	If ($_pdf_tFileName="")
		$_pdf_lError:=-3
	End if 
End if 

$_pdf_tAuthor:=""
$_pdf_tDocName:=""
$_pdf_tKeywords:=""
$_pdf_lDisallowCopy:=0
$_pdf_lDisallowAnnotate:=0
$_pdf_lDisallowModify:=0
$_pdf_lDisallowPrint:=0

If ($_pdf_lError=0)
	
	If (Count parameters:C259>=3)
		$_pdf_tAuthor:=$3
		If (Count parameters:C259>=4)
			$_pdf_tDocName:=$4
			If (Count parameters:C259>=5)
				$_pdf_tKeywords:=$5
				If (Count parameters:C259>=6)
					$_pdf_tAuthPass:=$6
					If (Count parameters:C259>=7)
						$_pdf_tReaderPass:=$7
						If (Count parameters:C259>=8)
							$_pdf_lDisallowCopy:=$8
							If (Count parameters:C259>=9)
								$_pdf_lDisallowAnnotate:=$9
								If (Count parameters:C259>=10)
									$_pdf_lDisallowModify:=$10
									If (Count parameters:C259>=11)
										$_pdf_lDisallowPrint:=$11
									End if 
								End if 
							End if 
						End if 
					End if 
				End if 
			End if 
		End if 
	End if 
	
End if 


// =================== [ Check Environment ] =====================

If ($_pdf_lError=0)
	If (Test path name:C476($_pdf_tOutputDir)#Is a folder:K24:2)
		$_pdf_lError:=-4
	End if 
End if 


If ($_pdf_lError=0)
	If (_info Mac=kTrue)
		
		TRACE:C157
		//9(Destination option)
		// 1=Printer,-
		// 2=File(PC)/PS(Mac),Access path
		// 3=PDF(Mac),Access path
		// 5=Screen(Mac)
		SET PRINT OPTION:C733(Destination option:K47:7; 3; $_pdf_tOutputDir+$_pdf_tFileName)  // $_pdf_tOutputDir contains Folder separator
		//SET PRINT OPTION(Destination option;5)
		
		//ARRAY TEXT(namesArray;0)
		//ARRAY TEXT(altNamesArray;0)
		//ARRAY TEXT(modelsArray;0)
		//PRINTERS LIST(namesArray;altNamesArray;modelsArray)
		//
		//$_pdf_tOldPrinter:=Get current printer
		//If ($_pdf_tOldPrinter=$_pdf_tDriverName)
		//  //already PDFDriver
		//Else 
		//SET CURRENT PRINTER($_pdf_tDriverName)
		//$_pdf_fSwitchedDriver:=True
		//  // Check if succesfully changed
		//If (Get current printer#$_pdf_tDriverName)
		//$_pdf_fSwitchedDriver:=False
		//$_pdf_lError:=-5
		//End if 
		//End if 
		
	Else 
		// windows parameters
		//<>_rep_tPDFCreatorName:=PDFCreator Printer name
		$_pdf_tDriverName:=<>_rep_tPDFCreatorName  // "PDFCreator"
		If ($_pdf_tFileName="@.pdf")
			$_pdf_tFileName:=_str_ LastPartRemove($_pdf_tFileName; ".")  // win driver will add .pdf 
		End if 
		// Check PDFCreator version
		ARRAY TEXT:C222($_pdf_atNamesArray; 0)
		PRINTERS LIST:C789($_pdf_atNamesArray)
		If (Find in array:C230($_pdf_atNamesArray; $_pdf_tDriverName)<1)
			$_pdf_lError:=-97
		End if 
		
		If ($_pdf_lError=0)
			C_TEXT:C284($_pdf_lDriverVersion)
			C_TEXT:C284($_pdf_tSelector)
			
			//$Selector_t:="Version"
			//GET PRINT OPTION(201;$Selector_t;$DriverVersion_l)
			GET PRINT OPTION:C734("PDFInfo:Version"; $_pdf_lDriverVersion)
			
			Case of 
				: ($_pdf_lDriverVersion="")
					//$_pdf_lError:=-100
					
					//: (Num(Substring($_pdf_lDriverVersion;5;1))<7)
				: ($_pdf_lDriverVersion<"0.9.9")
					$_pdf_lError:=-99
			End case 
		End if 
		
		
		If ($_pdf_lError=0)
			// This is optionnal.. I use it for tests only
			SET PRINT OPTION:C733("PDFOptions:PDF Reset standard options"; 0)  //PDFCreator Options;PDF Reset standard options)
		End if 
		
		
		If ($_pdf_lError=0)
			// same code upper this method
			//PDFCreator DriverName
			
			$_pdf_tOldPrinter:=Get current printer:C788
			If ($_pdf_tOldPrinter=$_pdf_tDriverName)
				//already PDFDriver
			Else 
				SET CURRENT PRINTER:C787($_pdf_tDriverName)
				$_pdf_fSwitchedDriver:=True:C214
				// Check if succesfully changed
				If (Get current printer:C788#$_pdf_tDriverName)
					$_pdf_fSwitchedDriver:=False:C215
					$_pdf_lError:=-5
				End if 
			End if 
		End if 
		
		
		// =================== [ Required parameters ] =====================
		// =============== Autosave - FileName ==============
		If ($_pdf_lError=0)
			// Add .pdf if necessary, must handle in the calling proc
			//If ($FileName_t#"@.pdf")
			//$FileName_t:=$FileName_t+".pdf"
			//End if 
			
			$_pdf_fValueSet:=_pdf_ PrintOptionTextSet("PDFOptions:AutosaveFilename"; $_pdf_tFileName)
			If ($_pdf_fValueSet=False:C215)
				$_pdf_lError:=-6
			End if 
		End if 
		
		// =============== Autosave - Directory ==============
		If ($_pdf_lError=0)
			TRACE:C157  // v12.2 new: test this SET PRINT OPTION
			// http://doc.4d.com/4D-Language-Reference-12.2/Printing/SET-PRINT-OPTION.301-643115.en.html
			SET PRINT OPTION:C733(Destination option:K47:7; 3; $_pdf_tOutputDir+$_pdf_tFileName)  // 3=PDF File, Access path
			$_pdf_fValueSet:=_pdf_ PrintOptionTextSet("PDFOptions:AutosaveDirectory"; $_pdf_tOutputDir)
			If ($_pdf_fValueSet=False:C215)
				$_pdf_lError:=-7
			End if 
		End if 
		
		// =================== [ Optionnam Parameters ] =====================
		
		// ================= OPTIONNAL PARAMETERS ===================
		// =============== Author ==============
		If ($_pdf_lError=0)
			$_pdf_fValueSet:=_pdf_ PrintOptionTextSet("PDFOptions:StandardAuthor"; $_pdf_tAuthor)
			If ($_pdf_fValueSet=False:C215)
				$_pdf_lError:=-8
			End if 
		End if 
		
		// =============== DocName ==============
		If ($_pdf_lError=0)
			If (Not:C34(_pdf_ PrintOptionTextSet("PDFOptions:StandardTitle"; $_pdf_tDocName)))
				$_pdf_lError:=-9
			End if 
		End if 
		
		If ($_pdf_lError=0)
			If (Not:C34(_pdf_ PrintOptionTextSet("PDFOptions:StandardKeywords"; $_pdf_tKeywords)))
				$_pdf_lError:=-9
			End if 
		End if 
		
		// =============== Author Pass ==============
		If ($_pdf_lError=0)
			$_pdf_fValueSet:=_pdf_ PrintOptionTextSet("PDFOptions:PDFOwnerPasswordString"; $_pdf_tAuthPass)
			If ($_pdf_fValueSet=False:C215)
				$_pdf_lError:=-10
			End if 
		End if 
		
		// =============== Reader Pass ==============
		If ($_pdf_lError=0)
			$_pdf_fValueSet:=_pdf_ PrintOptionTextSet("PDFOptions:PDFUserPasswordString"; $_pdf_tReaderPass)
			If ($_pdf_fValueSet=False:C215)
				$_pdf_lError:=-11
			End if 
		End if 
		
		// =============== Rigths ==============
		If ($_pdf_lError=0)
			$_pdf_fValueSet:=_pdf_ RightsSet($_pdf_lDisallowCopy; $_pdf_lDisallowAnnotate; $_pdf_lDisallowModify; $_pdf_lDisallowPrint)
			If (Not:C34($_pdf_fValueSet))
				$_pdf_lError:=-12
			End if 
		End if 
		
		//If ($_pdf_lError=0)
		//$_pdf_fValueSet:=_pdf_ PrintOptionLongSet ("PDFOptions:StartStandardProgram";1) // does not work
		//If ($_pdf_fValueSet=False)
		//$_pdf_lError:=-13
		//End if 
		//End if 
		
		
	End if   // end windows parameters
	
End if 

If ($_pdf_lError#0)
	// Error occured
	If ($_pdf_fSwitchedDriver)
		// Restore previously used driver
		SET CURRENT PRINTER:C787($_pdf_tOldPrinter)
	End if 
End if 

// ============================================================================
$0:=$_pdf_lError
//eof


